PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144685873"
 Author = "jayas.jayas"
 Desc = "Parallel Transmission Line using Single Phase"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 B4")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,36],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,756,1134]
    Posn = [18,36]
    Icon = [-1,-1]
    Extents = 0,0,756,1134
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,756,273],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(63454616,"V2a",0,,,)
     Curve(63457528,"V2b",1,,,)
     Curve(63485672,"V2c",2,,,)
     }
    Graph([0,273],[0,0,756,272],"Current")
     {
     Options = 9
     Units = ""
     Curve(63445984,"I2a",0,,,)
     Curve(63448736,"I2b",1,,,)
     Curve(63544096,"I2c",2,,,)
     }
    Graph([0,545],[0,0,756,272],"Current")
     {
     Options = 9
     Units = ""
     Curve(63541320,"I20",0,,,)
     }
    PGraph([0,817],[0,0,756,254],"PolyGraph")
     {
     Options = 2
     Curve(63464488,"Br2a",0,,,)
     Curve(63476408,"Br2b",1,,,)
     Curve(63467184,"Br2c",2,,,)
     }
    }
   -Plot-([792,36],0)
    {
    Title = "Plots at B4"
    Draw = 1
    Area = [0,0,738,1134]
    Posn = [792,36]
    Icon = [-1,-1]
    Extents = 0,0,738,1134
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,273],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(63701624,"V4a",0,,,)
     Curve(63704536,"V4b",1,,,)
     Curve(63755688,"V4c",2,,,)
     }
    Graph([0,273],[0,0,738,272],"Current")
     {
     Options = 9
     Units = ""
     Curve(63707624,"I4a",0,,,)
     Curve(63710536,"I4b",1,,,)
     Curve(63713456,"I4c",2,,,)
     }
    Graph([0,545],[0,0,738,272],"Current")
     {
     Options = 9
     Units = ""
     Curve(63871976,"I40",0,,,)
     }
    PGraph([0,817],[0,0,738,254],"PolyGraph")
     {
     Options = 2
     Curve(63379032,"Br4a",0,,,)
     Curve(63737696,"Br4b",1,,,)
     Curve(63740472,"Br4c",2,,,)
     }
    }
   }
  }
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144685614
  Nodes = 
   {
   Output("F",36,18)
    {
    Type = Integer
    }
   Input("Flt_en",36,-18)
    {
    Type = Integer
    }
   Output("B",36,-36)
    {
    Type = Integer
    Dim  = [6]
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Line(34,-18,27,-18)
   Pen(Gray)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   -Sticky-([72,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,666,180,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -Wire-([648,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([684,684],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([684,720],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([810,702],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1422,1170],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1422,1170],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(63805944)
    Meter(63858560)
    Slider(63803088)
    Meter(63749832)
    Meter(63493520)
    Meter(63524992)
    Meter(63731872)
    Meter(63734784)
    }
   -Sticky-([522,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 522,108,684,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.arrow_a([522,216],1,0,-1)
    {
    }
   0.datalabel([1530,828],3,0,-1)
    {
    Name = "B4T1"
    }
   0.datalabel([1458,1008],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1458,1026],6,0,-1)
    {
    Name = "B2"
    }
   -Sticky-([1260,162],0)
    {
    Name = ""
    Font = 1
    Bounds = 1260,162,1368,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Wire-([648,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -ControlPanel-([1260,414],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(62988416)
    Slider(62999648)
    Slider(63014760)
    }
   0.datalabel([1530,882],3,0,-1)
    {
    Name = "B4T2"
    }
   -ControlPanel-([1260,774],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(63010216)
    Slider(62937560)
    Slider(62934408)
    }
   0.var([1494,882],0,62934408,270)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1494,828],0,62937560,220)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.tfaultn([774,702],4,0,370)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Sticky-([18,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,198,144,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(63800064)
    Meter(63852816)
    Slider(63797208)
    Meter(63746920)
    Meter(63758600)
    Meter(63527904)
    Meter(63794296)
    Meter(63728792)
    }
   -Wire-([1656,324],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1656,360],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([1692,504],6,0,340)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([1692,324],0,0,310)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1728,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1728,288],0,62984464,10)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.datalabel([1836,324],4,0,-1)
    {
    Name = "B1"
    }
   -Wire-([1728,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1728,450],6,62988416,110)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1764,468],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([1836,468],2,0,-1)
    {
    Name = "B2"
    }
   0.tbreakn([1602,324],4,0,300)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.tbreakn([1602,504],4,0,330)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   0.datalabel([1530,360],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([1530,414],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1530,468],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([1494,414],0,62996872,50)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1494,468],0,62999648,90)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1530,522],3,0,-1)
    {
    Name = "B2T2"
    }
   0.var([1494,360],0,63003568,20)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([1404,162],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1404,162,1566,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   0.logic([1800,324],6,0,320)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([1764,882],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.logic([1800,882],6,0,290)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1728,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1836,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1872,846],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.var_switch([1836,828],6,63010216,240)
    {
    Name = "42-B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.logic([1908,846],0,0,400)
    {
    Type = "2"
    Inv = "0"
    }
   0.tbreakn([1710,882],4,0,280)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   0.var([1494,522],0,63014760,120)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.logic([1800,468],0,0,410)
    {
    Type = "2"
    Inv = "0"
    }
   0.var([1980,360],0,63018624,30)
    {
    Name = "B3AT1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.35"
    Units = "s"
    Collect = "1"
    }
   0.logic([2052,540],0,0,350)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1764,792],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.logic([2052,630],6,0,380)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([2016,594],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1998,576],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([2016,684],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.var_switch([2052,666],0,63024816,170)
    {
    Name = "42-B3B"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.datalabel([2160,540],4,0,-1)
    {
    Name = "B3A"
    }
   0.datalabel([2160,666],4,0,-1)
    {
    Name = "B3B"
    }
   0.logic([2124,666],6,0,390)
    {
    Type = "2"
    Inv = "0"
    }
   0.logic([2052,774],6,0,230)
    {
    Type = "1"
    Inv = "0"
    }
   0.var_switch([2052,810],0,63031168,250)
    {
    Name = "42-B3C"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.logic([2124,810],6,0,260)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([2160,810],4,0,-1)
    {
    Name = "B3C"
    }
   -Wire-([1926,738],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([1926,576],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   0.datalabel([2016,360],3,0,-1)
    {
    Name = "B3AT1"
    }
   0.datalabel([2070,360],3,0,-1)
    {
    Name = "B3BT1"
    }
   0.datalabel([2016,414],3,0,-1)
    {
    Name = "B3AT2"
    }
   0.datalabel([2070,414],3,0,-1)
    {
    Name = "B3BT2"
    }
   0.datalabel([2124,360],3,0,-1)
    {
    Name = "B3CT1"
    }
   0.datalabel([2124,414],3,0,-1)
    {
    Name = "B3CT2"
    }
   0.var([2088,360],0,63040976,60)
    {
    Name = "B3CT1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.var([2034,360],0,63043616,40)
    {
    Name = "B3BT1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.var([2034,414],0,63046336,80)
    {
    Name = "B3BT2"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.var([1980,414],0,63049224,70)
    {
    Name = "B3AT2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.42"
    Units = "s"
    Collect = "1"
    }
   -ControlPanel-([72,720],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(63762760)
    Dial(63789136)
    Slider(63102416)
    Slider(63105184)
    Slider(63879064)
    }
   0.datamerge([1476,1080],4,0,420)
    {
    N = "6"
    Type = "1"
    Disp = "1"
    }
   0.datalabel([1458,1098],6,0,-1)
    {
    Name = "B4"
    }
   -Wire-([1440,1044],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1440,1044],6,0,-1)
    {
    Name = "B3A"
    }
   -Wire-([1440,1062],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1440,1062],6,0,-1)
    {
    Name = "B3B"
    }
   -Wire-([1422,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1422,1080],6,0,-1)
    {
    Name = "B3C"
    }
   0.export([1512,1134],4,0,440)
    {
    Name = "B"
    }
   0.export([1512,1170],4,0,430)
    {
    Name = "F"
    }
   0.tbreakn([1980,540],4,0,140)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B3AT1"
    TO2 = "B3AT2"
    }
   0.tbreakn([1980,684],4,0,180)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B3BT1"
    TO2 = "B3BT2"
    }
   0.tbreakn([1980,774],4,0,210)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B3CT1"
    TO2 = "B3CT2"
    }
   -Wire-([1692,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.unity([1692,792],0,0,200)
    {
    IType = "1"
    OType = "1"
    }
   0.import([1620,792],0,0,190)
    {
    Name = "Flt_en"
    }
   0.datalabel([1944,846],2,0,-1)
    {
    Name = "B4"
    }
   0.datalabel([1764,792],2,0,-1)
    {
    Name = "Flt_en2"
    }
   -Wire-([1656,504],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1656,414],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([1926,576],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.datalabel([1602,414],2,0,-1)
    {
    Name = "Flt_en2"
    }
   0.datalabel([1926,576],2,0,-1)
    {
    Name = "Flt_en2"
    }
   0.var_switch([2052,504],0,63098616,130)
    {
    Name = "42-B3A"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.logic([2124,540],6,0,360)
    {
    Type = "2"
    Inv = "0"
    }
   0.var([612,684],0,63102416,150)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   0.var([612,720],0,63105184,160)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.16"
    Units = ""
    Collect = "1"
    }
   -Sticky-([72,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,864,216,1170
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source
          and  B1
  2=> FT2: 
          Between B1 
          and Line
  3=> FT3: 
          Between Line 1
          and B2
  4=> FT4: 
          Between Source
          and B2
  5=> FT5:
          Between B3
          and Line 2
  6=> FT6:
          Between Line 2 
          and B4 "
    }
   -Sticky-([252,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 252,864,378,1080
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> No Fault
11=> No fault (0)"
    }
   -Sticky-([828,594],0)
    {
    Name = ""
    Font = 1
    Bounds = 828,594,1152,1062
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Example of a Single Phase Breaker Trip Test  Sequence:
 
B3 is controlled as a single phase breaker.

The Fault is located on Line 2 at B3 (Fault location 5), 
and is an A phase to Ground fault (Fault Type 1).

The Fault occurs at 0.2 sec, and has a duration of 0.16 sec.

Set Breakers 1, 2 and 4:
B1T1 = 2.0:  Breaker B1 does not trip.
B2T1 = 2.0:  Breaker B2 does not trip.
B4T1 = 2.0:  Breaker B4 does not trip.
B1T2 = 2.0:  Breaker B1 does not reclose.
B2T2 = 2.0:  Breaker B2 does not reclose.
B4T2 = 2.0:  Breaker B4 does not reclose.

Set Breaker B3:
B3AT1 = 0.35:  Breaker B3A trips at 35 msec.
B3BT1 = 2.00:  Breaker B3B does not trip.
B3CT1 = 2.00:  Breaker B3C does not trip.
B3AT2 = 0.42:  Breaker B3A recloses at 42 msec.
B3BT2 = 2.00:  Breaker B3B does not reclose.
B3CT2 = 2.00:  Breaker B3C does not reclose.

(Breaker B1, B2 and B4 do not automatically operate)
"
    }
   0.var([2088,414],0,63113776,100)
    {
    Name = "B3CT2"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   -ControlPanel-([1260,630],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,504,126
    Switch(63098616)
    Slider(63018624)
    Slider(63049224)
    Slider(63043616)
    Slider(63046336)
    Slider(63040976)
    Slider(63113776)
    }
   -Sticky-([1404,954],0)
    {
    Name = ""
    Font = 1
    Bounds = 1404,954,1512,990
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -ControlPanel-([1260,270],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(62984464)
    Slider(63003568)
    Slider(62996872)
    }
   -Sticky-([936,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 936,108,1044,144
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback  Recorders"
    }
   -ControlPanel-([936,162],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(63935240)
    Slider(63931216)
    }
   -ControlPanel-([864,324],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,288,126
    Switch(63915568)
    Switch(63898096)
    Switch(63918288)
    Switch(63921176)
    }
   -Sticky-([882,468],0)
    {
    Name = ""
    Font = 1
    Bounds = 882,468,1134,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, click on the switch.
On = Recorder will record data.
Off = Recorder will NOT record data.

You can turn on or off each recorder individually."
    }
   -Divider-([1188,936],0)
    {
    Size(1170,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1188,72],0)
    {
    Size(0,1440)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([18,576],0)
    {
    Size(1170,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([810,72],0)
    {
    Size(0,504)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 B3")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,36],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,720,1152]
    Posn = [18,36]
    Icon = [-1,-1]
    Extents = 0,0,720,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,720,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(63744144,"V1a",0,,,)
     Curve(63470856,"V1b",1,,,)
     Curve(63451704,"V1c",2,,,)
     }
    Graph([0,277],[0,0,720,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(63530848,"I1a",0,,,)
     Curve(63547152,"I1b",1,,,)
     Curve(63533760,"I1c",2,,,)
     }
    Graph([0,554],[0,0,720,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(63537512,"I10",0,,,)
     }
    PGraph([0,831],[0,0,720,258],"PolyGraph")
     {
     Options = 2
     Curve(63874968,"Br1a",0,,,1)
     Curve(63473632,"Br1b",1,,,1)
     Curve(63519960,"Br1c",2,,,1)
     }
    }
   -Plot-([792,36],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,720,1152]
    Posn = [792,36]
    Icon = [-1,-1]
    Extents = 0,0,720,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,720,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(63681240,"V3a",0,,,)
     Curve(63684016,"V3b",1,,,)
     Curve(63686928,"V3c",2,,,)
     }
    Graph([0,277],[0,0,720,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(63689840,"I3a",0,,,)
     Curve(63692752,"I3b",1,,,)
     Curve(63695664,"I3c",2,,,)
     }
    Graph([0,554],[0,0,720,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(63698656,"I30",0,,,)
     }
    PGraph([0,831],[0,0,720,258],"PolyGraph")
     {
     Options = 2
     Curve(63716368,"Br3a",0,,,1)
     Curve(63719144,"Br3b",1,,,1)
     Curve(63726016,"Br3c",2,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144685613
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.pgb([2250,1242],0,63379032,1130)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([432,1152],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([468,1152],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([504,1152],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([432,1332],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([468,1332],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([504,1332],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1818,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1836,1242],0,0,290)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1836,1278],0,0,400)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([324,1152],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([360,1152],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([396,1152],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([324,1332],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([360,1332],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([396,1332],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([2214,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2214,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2214,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2214,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1980,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1980,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1980,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1854,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1854,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1854,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1962,1314],0,0,500)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1962,1278],0,0,450)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1962,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1962,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1962,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1836,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1836,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1836,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1836,1314],0,0,480)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1962,1242],0,0,330)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1944,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1116,1134],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1026,1224],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([1062,1224],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([1098,1224],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([1080,1314],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([1026,1476],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([1062,1476],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([1098,1476],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([1116,1386],2,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([2178,972],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([1980,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1854,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([792,720],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([324,612],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([342,720],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([342,738],0,0,-1)
    {
    Name = "F1"
    }
   0.pgb([2358,1314],0,63418328,530)
    {
    Name = "V3rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([2358,1350],0,63421104,540)
    {
    Name = "V4rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([774,522],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([774,540],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([774,756],0,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([774,774],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([1080,1134],2,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1170,1224],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([1206,1476],0,0,-1)
    {
    Name = "F6"
    }
   0.breaker3([900,504],0,0,700)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "69.75 [MW]"
    Q = "-17.44 [MVAR]"
    }
   0.datalabel([558,522],0,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([558,540],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([558,756],0,0,-1)
    {
    Name = "FT5"
    }
   -Wire-([540,720],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([504,504],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([702,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([720,1440],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([702,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([720,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1350,1368],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([1350,1404],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([1350,1440],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1476,1368],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1476,1404],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1512,1368],0,63445984,1060)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1512,1404],0,63448736,1000)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1386,1314],0,63451704,370)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1512,1242],0,63454616,230)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1512,1278],0,63457528,300)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.datalabel([1584,1242],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1584,1278],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1584,1314],0,0,-1)
    {
    Name = "Br1C"
    }
   0.datalabel([1710,1242],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1710,1278],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1746,1242],0,63464488,1180)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1746,1314],0,63467184,1100)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1584,1368],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([1386,1278],0,63470856,260)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1620,1278],0,63473632,1170)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1746,1278],0,63476408,1150)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1332,1242],0,0,190)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1332,1278],0,0,250)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1314,1206],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([1350,1242],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([1350,1278],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1476,1278],2,0,-1)
    {
    Name = "V2B"
    }
   0.pgb([1512,1314],0,63485672,410)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   -Wire-([1584,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1584,1440],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1584,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1584,1476],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1710,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1710,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1710,1476],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1476,1242],2,0,-1)
    {
    Name = "V2A"
    }
   0.pgb([1746,1368],0,63493520,1010)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.datalabel([1710,1440],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1710,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1710,1404],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1710,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1710,1368],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1710,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1710,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1710,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1710,1314],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1476,1440],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1476,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1476,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1476,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1350,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1350,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1350,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1584,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1584,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1584,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1584,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1584,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1476,1314],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1458,1314],0,0,390)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1458,1278],0,0,270)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1458,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1458,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1458,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1350,1314],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([1332,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1332,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1332,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1332,1314],0,0,350)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1584,1404],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1620,1314],0,63519960,1120)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1458,1242],0,0,220)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1440,1206],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([1440,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1746,1404],0,63524992,960)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1620,1404],0,63527904,980)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1386,1368],0,63530848,1070)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "1.5"
    }
   0.pgb([1386,1440],0,63533760,940)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "1.5"
    }
   -Wire-([1476,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1350,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1386,1476],0,63537512,820)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.5"
    Max = "0.3"
    }
   0.datalabel([1476,1476],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1512,1476],0,63541320,790)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.4"
    Max = "0.5"
    }
   0.pgb([1512,1440],0,63544096,890)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1386,1404],0,63547152,1020)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "1.5"
    }
   -Wire-([1314,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1350,1476],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([1818,1206],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1854,1242],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1854,1278],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1854,1314],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1980,1242],2,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([1980,1278],2,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([1980,1314],2,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([774,1152],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([810,1152],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([846,1152],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([774,1332],6,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([810,1332],6,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([846,1332],6,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1854,1368],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1854,1404],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1854,1440],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1854,1476],0,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([1980,1368],0,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([1980,1404],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([1980,1440],0,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([1980,1476],0,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([882,1152],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([918,1152],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([954,1152],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([882,1332],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([918,1332],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([954,1332],2,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([2124,972],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([504,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([504,1476],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2088,1368],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([2088,1404],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([2088,1242],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([2088,1278],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([2088,1314],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([2214,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2214,1242],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([2214,1278],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([2214,1314],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([2214,1368],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([2214,1404],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([1890,1242],0,63681240,310)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1890,1278],0,63684016,420)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1890,1314],0,63686928,490)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1890,1368],0,63689840,990)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1890,1404],0,63692752,880)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1890,1440],0,63695664,770)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1890,1476],0,63698656,730)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "3.0"
    }
   0.pgb([2016,1242],0,63701624,340)
    {
    Name = "V4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([2016,1278],0,63704536,470)
    {
    Name = "V4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([2016,1368],0,63707624,970)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([2016,1404],0,63710536,830)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([2016,1440],0,63713456,750)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([2124,1242],0,63716368,1140)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2124,1278],0,63719144,1090)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2124,1314],0,63726016,1050)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2124,1404],0,63728792,800)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2250,1368],0,63731872,870)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([2250,1404],0,63734784,780)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2250,1278],0,63737696,1080)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2250,1314],0,63740472,1030)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([558,774],0,0,-1)
    {
    Name = "F5"
    }
   0.pgb([1386,1242],0,63744144,200)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([2358,1242],0,63746920,460)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([2358,1278],0,63749832,510)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([396,612],0,0,-1)
    {
    Vertex="0,0;-144,0"
    }
   -Wire-([936,612],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datalabel([972,738],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([972,720],0,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([990,612],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([2016,1314],0,63755688,520)
    {
    Name = "V4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1620,1368],0,63758600,1040)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   -Wire-([2178,918],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.datalabel([1044,1152],0,0,-1)
    {
    Name = "Breaker"
    }
   0.var_pot([1008,1350],0,63762760,360)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "6"
    Value = "5"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([1080,1350],0,0,380)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([1944,1206],2,0,-1)
    {
    Name = "V4"
    }
   0.mux_array([1098,1422],6,0,610)
    {
    DPath = "0"
    }
   0.datatap([1080,1134],6,0,670)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1116,1134],6,0,660)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1026,1224],6,0,1260)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1062,1224],6,0,1250)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1098,1224],6,0,1240)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1134,1224],6,0,1230)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1170,1224],6,0,1220)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1206,1224],6,0,1210)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1134,1224],2,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([1188,1242],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datatap([1026,1476],0,0,950)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1062,1476],0,0,920)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1098,1476],0,0,910)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1134,1476],0,0,900)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1170,1476],0,0,860)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1206,1476],0,0,850)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1206,1224],2,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([1170,1476],0,0,-1)
    {
    Name = "F5"
    }
   -Wire-([1188,1458],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datalabel([1134,1476],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([2124,936],4,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([2124,936],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var_pot([1188,1350],2,63789136,430)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "1"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.unity([1116,1350],4,0,590)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([1116,1350],1,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([1116,1314],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.pgb([2124,1368],0,63794296,930)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.var([180,684],3,63797208,50)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([234,684],3,63800064,60)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1116,684],5,63803088,90)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1062,684],5,63805944,80)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.datalabel([2124,918],4,0,-1)
    {
    Name = "Breaker"
    }
   0.datatap([1152,1134],6,0,650)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1260,1134],2,0,-1)
    {
    Name = "B4"
    }
   -Wire-([1242,1152],0,0,-1)
    {
    Vertex="0,0;-198,0"
    }
   0.datatap([1188,1134],6,0,640)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1224,1134],6,0,630)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1260,1134],6,0,620)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1152,1134],2,0,-1)
    {
    Name = "B3A"
    }
   0.datalabel([1224,1134],2,0,-1)
    {
    Name = "B3C"
    }
   0.datalabel([1188,1134],2,0,-1)
    {
    Name = "B3B"
    }
   0.source3R([1080,612],2,0,570)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.source3R([216,612],6,0,560)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.breaker3([900,720],0,0,680)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "70.52 [MW]"
    Q = "-17.11 [MVAR]"
    }
   -Wire-([1080,1530],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1152,1530],0,0,-1)
    {
    Name = "Ron"
    }
   0.tpflt([306,702],0,0,1320)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([522,504],0,0,1340)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([522,738],0,0,1310)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([810,504],4,0,1330)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([810,738],4,0,1290)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1008,702],4,0,1300)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.recorder2_0([846,1404],0,0,1110)
    {
    FName = "stn4"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "4"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([954,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([954,1476],0,0,-1)
    {
    Name = "Fault"
    }
   0.annotation([1044,1512],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.pgb([1620,1440],0,63852816,840)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1620,1476],0,63855648,760)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1746,1440],0,63858560,810)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1746,1476],0,63861560,740)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   -Bus-([936,486],0,58950184,-1)
    {
    P1 = [0,0]
    P2 = [0,270]
    I = 1
    NAME = BUS2
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   -Bus-([396,486],0,58007120,-1)
    {
    P1 = [0,0]
    P2 = [0,270]
    I = 1
    NAME = BUS1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.breaker3([432,504],4,0,710)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-68.36 [MW]"
    Q = "4.78 [MVAR]"
    }
   -Sticky-([18,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,18,504,198
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Description: 
- Two Thevinen Impedance sources connected via two 100km transmission lines.
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via two transmission lines.
- Six fault positions for full fault control ahead and behind station relays.
- Four breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is implemented for Breaker B3."
    }
   .Plots_B1([432,378],0,0,10)
    {
    }
   0.pgb([2016,1476],0,63871976,720)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.3"
    Max = "0.5"
    }
   0.pgb([1620,1242],0,63874968,1190)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   -Sticky-([1314,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 1314,1116,1422,1152
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.mux_array([1098,1278],0,0,1200)
    {
    DPath = "0"
    }
   0.var([1044,1530],0,63879064,550)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   0.recorder2_0([846,1224],0,0,1270)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.const([144,1134],1,0,120)
    {
    Name = ""
    Value = "10.0"
    }
   -Wire-([72,1206],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.const([180,1368],1,0,210)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([216,1404],6,0,280)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([630,1368],1,0,320)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([666,1404],6,0,440)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.var_switch([216,1332],1,63898096,180)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   -Wire-([270,1440],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.recorder2_0([396,1404],0,0,1160)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   -Wire-([270,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([720,1548],0,0,-1)
    {
    Vertex="0,0;-450,0"
    }
   -Wire-([252,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([558,1530],0,0,-1)
    {
    Vertex="0,0;-432,0"
    }
   -Wire-([558,1440],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([558,1260],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([558,1260],0,0,-1)
    {
    Vertex="0,0;0,270"
    }
   0.var_switch([180,1098],1,63915568,110)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([666,1152],1,63918288,140)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([666,1332],1,63921176,240)
    {
    Name = "en Record4"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   .Controls([2214,954],4,0,600)
    {
    }
   -Wire-([270,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([126,1440],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.select([666,1224],6,0,170)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([630,1188],1,0,150)
    {
    Name = ""
    Value = "10.0"
    }
   0.var([234,1260],0,63931216,160)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   0.select([180,1170],6,0,580)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([126,1206],0,0,-1)
    {
    Vertex="0,0;0,324"
    }
   0.var([36,1206],0,63935240,130)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   0.recorder2_0([396,1224],0,0,1280)
    {
    FName = "stn1"
    FFMT = "0"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   -Wire-([252,1170],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([288,1224],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([252,1170],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([720,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -TLine-([558,504],0,48439280,-1)
    {
    Name = "LINE1"
    Date = 1144685614
    Freq = "$(f)"
    Length = "100.0"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_FreDep_Options([738,378],0,57458696,-1)
      {
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      FT = "2000 [Hz]"
      ZMaxP = "20"
      AMaxP = "20"
      ZMaxE = "2 [%]"
      AMaxE = "2 [%]"
      Interp1 = "1"
      Output = "0"
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      Inflen = "0"
      }
     0.Line_Ground([630,702],0,57459944,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([198,468],0,57460296,-1)
      {
      Mode = "0"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,58495784,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -TLine-([558,720],0,58411512,-1)
    {
    Name = "LINE2"
    Date = 1144685615
    Freq = "$(f)"
    Length = "100.0"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_FreDep_Options([738,378],0,58412736,-1)
      {
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      FT = "2000 [Hz]"
      ZMaxP = "20"
      AMaxP = "20"
      ZMaxE = "2 [%]"
      AMaxE = "2 [%]"
      Interp1 = "1"
      Output = "0"
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      Inflen = "0"
      }
     0.Line_Ground([630,702],0,56519384,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([216,468],0,56519760,-1)
      {
      Mode = "0"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,56557712,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -Wire-([828,720],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([828,504],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([504,720],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Sticky-([1026,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 1026,504,1116,540
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   -Sticky-([162,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 162,504,252,540
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   .Plots_B2([900,378],0,0,20)
    {
    }
   0.breaker3([432,720],4,0,690)
    {
    Ctrl = "1"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "B3A"
    NAMEB = "B3B"
    NAMEC = "B3C"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-69.16 [MW]"
    Q = "4.894 [MVAR]"
    }
   -Sticky-([270,828],0)
    {
    Name = ""
    Font = 1
    Bounds = 270,828,612,900
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Breaker B3  is set for Single Pole Operation:
Instead of a single command, B3, opening and closing all 3 phases,
there are three commands, B3A, B3B and B3C, one for each Phase.  
"
    }
   -Sticky-([756,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 756,36,1152,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   0.multimeter([486,720],0,0,70)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V3"
    P = ""
    Q = ""
    Vrms = "V3rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([486,504],0,0,30)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([846,504],4,0,40)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([846,720],4,0,100)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V4"
    P = ""
    Q = ""
    Vrms = "V4rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([2322,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2322,1242],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([2322,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2322,1278],0,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([2322,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2322,1314],0,0,-1)
    {
    Name = "V3rms"
    }
   -Wire-([2322,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2322,1350],0,0,-1)
    {
    Name = "V4rms"
    }
   -Divider-([18,1044],0)
    {
    Size(2376,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 }

